﻿<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Skrócona lista pracowników etatowych</title>
		<script runat="server">

		public enum RodzajZatr {
            PracownicyTymczasowi, Wszyscy
        }
		        
		public class PrnParams: ContextBase {
		
			public PrnParams(Context context): base(context) {
				data = GetToday();
			}
			Date data;
			[Priority(10)]
			public Date Data {
				get { return data; }
				set {
					if (value==Date.Empty)
						data = GetToday();
					else
						data = value;
					OnChanged(EventArgs.Empty);
				}
			}
			
			[Priority(20)]
			public FromTo Okres {
				get {
					YearMonth to = new YearMonth(data);			
					return new FromTo((to-35).FirstDay, to.LastDay);
				}
			}

            RodzajZatr rodzaj = RodzajZatr.PracownicyTymczasowi;
            [Caption("Rodzaj zatrudnienia")]
            [Priority(30)]
            public RodzajZatr Rodzaj {
                get { return rodzaj; }
                set {
                    rodzaj = value;
                    OnChanged(EventArgs.Empty);
                }
            }
            			
			Date GetToday() {
				if (Context.Contains(typeof(ActualDate)))
					return ((ActualDate)Context[typeof(ActualDate)]).Actual;
				return Date.Today;
			}
		}
		
		class Item: IComparable {
		
			Pracownik pracownik;
			Wydzial	wydział;
			public Periods zatrudnienie;
			
			public Item(PracHistoria ph) {
				pracownik = ph.Pracownik;
				wydział = ph.Etat.Wydzial;
			}
			public void Add(FromTo okres) {
				zatrudnienie += okres;
			}
			public Pracownik Pracownik {
				get { return pracownik; }
			}
			public Wydzial Wydział {
				get { return wydział; }
			}
			public StazPracy StażPracy(FromTo okres) {
                Periods ps = zatrudnienie.ToFlat() * okres;
				StazPracy staz = StazPracy.Empty;
				foreach (FromTo pso in ps)
					staz += new StazPracy(pso, pracownik);
				return staz.Normalizuj();
			}
			
			public int CompareTo(object v) {
				if (v==null)
					return 1;
				Item item = v as Item;
				if (item==null)
					throw new ArgumentException();
				return Wydział.Nazwa.CompareTo(item.Wydział.Nazwa);
			}
		}
    
		Date data;
        RodzajZatr rodzaj;    
		[Context]
		public PrnParams Pars {
			set {
                data = value.Data;
                rodzaj = value.Rodzaj;
            }
		}
		
        FromTo okres36;
        FromTo okres24;
        FromTo okres12;
                
        void OnContextLoad(Object sender, EventArgs args) {               
			YearMonth to = new YearMonth(data);
			
			okres36 = new FromTo((to-35).FirstDay, to.LastDay);
			okres24 = new FromTo((to-23).FirstDay, to.LastDay);
			okres12 = new FromTo((to-11).FirstDay, to.LastDay);
			
			ReportHeader1["OKRES"] = okres36.ToString();

			Row[] rows = (Row[])dc[typeof(Row[])];
			ArrayList lista = new ArrayList();
			foreach (Pracownik idx in rows) {
				Hashtable wgwdz = new Hashtable();
				foreach (PracHistoria ph in idx.Historia.GetIntersectedRows(okres36)) {
                    if (rodzaj == RodzajZatr.PracownicyTymczasowi)
                        if ((ph.Etat.RodzajZatrudnienia != RodzajZatrudnienia.PracownikTymczasowy) &&
                            (ph.Etat.RodzajZatrudnienia != RodzajZatrudnienia.PracownikTymczasowyZaGranicą))
                            continue;
                    FromTo zatr = ph.Etat.EfektywnyOkres * okres36;
					if (zatr!=FromTo.Empty) {
						Item item = (Item)wgwdz[ph.Etat.Wydzial];
						if (item==null)
							wgwdz.Add(ph.Etat.Wydzial, item = new Item(ph));
						item.Add(zatr);
					}					
				}
				ArrayList zatrl = new ArrayList(wgwdz.Values);
				zatrl.Sort();
				foreach (object v in zatrl)
					lista.Add(v);
			}
           
			Grid1.DataSource = lista;
		}      
    
		void Grid1_BeforeRow(Object sender, RowEventArgs args) {
			Item item = (Item)args.Row;
			
			col36.EditValue = item.StażPracy(okres36);
			col24.EditValue = item.StażPracy(okres24);
			col12.EditValue = item.StażPracy(okres12);
			
			foreach (FromTo okres in item.zatrudnienie)
				colZatr.AddLine(okres);
		}

		static void Msg(object value) {
		}

		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="PracListaSkrócona" method="post" runat="server">
			<EA:DATACONTEXT id="dc" runat="server" oncontextload="OnContextLoad" TypeName="Soneta.Business.Row[], Soneta.Business"></EA:DATACONTEXT>
			<cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Zestawienie zatrudnienia pracowników tymczasowych|</strong>Za okres: <strong>%OKRES%"
				runat="server"></cc1:reportheader>
			<EA:GRID id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" GroupData0="Pracownik" GroupLine="{0}">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP."></ea:GridColumn>
					<ea:GridColumn DataMember="Wydział" Caption="Zakład"></ea:GridColumn>
					<ea:GridColumn Width="25" Caption="Okresy zatrudnienia" ID="colZatr"></ea:GridColumn>
					<ea:GridColumn Width="12" Align="Center" Caption="Staż~ostatnie 36 miesięcy" Format="{0:b}" ID="col36"></ea:GridColumn>
					<ea:GridColumn Width="12" Align="Center" Caption="Staż~ostatnie 24 miesiące" Format="{0:b}" ID="col24"></ea:GridColumn>
					<ea:GridColumn Width="12" Align="Center" Caption="Staż~ostatnie 12 miesięcy" Format="{0:b}" ID="col12"></ea:GridColumn>
				</Columns>
			</EA:GRID>
			<cc1:reportfooter id="ReportFooter1" runat="server"></cc1:reportfooter>
		</form>
	</body>
</HTML>
